Attribute VB_Name = "mdDrawAngularDimension"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function DrawAngularDimension(Design, drawdoc, graphSet)

'Get the ProDESKTOP Application object
GetApplicationObject

' Get the Drawing Object pointer
Dim draw As aDrawing
Set draw = drawdoc.GetDrawing

Dim ddetail As aDesignDetail
Set ddetail = draw.GetDetail(Design, False)

Dim graphSetIt As Iterator
Set graphSetIt = app.GetClass("It").CreateAObjectIt(graphSet)

' Get the paper geometry corresponding to the first selected item
Dim graph1 As aGraphic
Set graph1 = graphSetIt.start
Dim geom1 As zGeometry
Set geom1 = drawdoc.GetPaperGeometry(graph1)

' Get the paper geometry corresponding to the second selected item
Dim graph2 As aGraphic
Set graph2 = graphSetIt.Next
Dim geom2 As zGeometry
Set geom2 = drawdoc.GetPaperGeometry(graph2)

' Get the design Instance of selected items
Dim view1 As aHiddenLine
Dim view2 As aHiddenLine
Set view1 = geom1.GetInstance
Set view2 = geom2.GetInstance

'create dimension
Dim defn As zMidPlane
Dim plane1 As zPlane
Dim plane2 As zPlane
Set plane1 = geom1
Set plane2 = geom2
Set defn = app.GetClass("MidPlane").CreateMidPlane(plane1, plane2, False)

Dim dimension As aDimension
Set dimension = app.GetClass("Dimension").CreateDimension(ddetail, 4, defn)
    
'Set the position for the dimension line
Dim position As zVector
Set position = app.GetClass("Vector").CreateVector(0.2, 0.1, 0)
    
' Create the linear dimension line
Dim AngularDim As Object
Set AngularDim = app.GetClass("AngularDimLine").CreateAngularDimLine(position, dimension, view1, view2)
Dim tolerance As aDimTol
Set tolerance = app.GetClass("DimTol").CreateDimTol(ddetail, dimension)

Dim Callout As aCallout
Set Callout = app.GetClass("DimensionCallout").CreateDimensionCallout(tolerance)

Dim text As aDimLineText
Dim vector As zVector
Set text = app.GetClass("DimLineText").CreateDimLineText(AngularDim, Callout, position, 0.0035)

' 1 is for aCalloutGroup::topCenter
text.SetControlPoint 1, position
   
'Add the dimension line to the drawing.
draw.AddDimLine AngularDim

'Add CenterLine
'To be done


End Function
